#!/usr/bin/perl

my $filename		=	"";
my $filenamepath	=	"/tmp/com.vara.automator.screenflowrecorderfile.txt";

if (-e $filenamepath) {
	$filename	=	`cat $filenamepath`;
	system("unlink $filenamepath");
}

my $pid		=	recorder_pid();

my $err		=	system("killall -2 screenflowrecorder 2> /dev/null");

if ($err != 0) {
	print "ScreenFlow Recorder not running\n";
	exit -1;
}

# wait for process to go down
if ($pid == 0) {
	sleep 3;
}
else {
	my $cnt = 0;
	while ($cnt < 10 && recorder_pid() != 0) {
		sleep 1;
	}
}

if (length($filename) <= 0) {
	# get most recent matching pattern recording*.scc desktop:
	$regex		=	'^recording[0-9]*[.]scc$';
	$filename = `ls -t ~/Desktop | grep --regexp '$regex' | head -1`;
	$filename = "~/Desktop/$filename";
}

print $filename;

# should probably move to another action...
#`/Applications/ScreenFlow.app/Contents/MacOS/ScreenFlow "$filename"`;

exit 0;


sub recorder_pid
{
	my $pid = 0;
	
	open(PS_F, "ps ax -o pid,command|"); 
	while (<PS_F>) { 
		($ps_pid,$ps_name) = split;
		if ($ps_name =~ /screenflowrecorder/) {
			$pid = $ps_pid
		}
	} 
	close(PS_F);
	
	return $pid;	
}
